#include <struct.h>

//------------------------------------------------------------------
// Cone Tool goes here.

DWORD CALLBACK ConePreMode(tProcParams* params)
{
  CurrentState.SetState(
    Z3D_STATE_WAITFOR_FIRSTCLICK);
  return 0;
}

DWORD CALLBACK ConeOnLButtonDown(tProcParams* params)
{
  // the tool doesn't support Mapper view.
  if (params->ViewDesc->Kind == Z3D_VIEWMODE_MAPPER)
    return 0;

  // if we are still expecting first click,
  // then we've got it. Now wait for second one.
  if (!CurrentState.IsState(
    Z3D_STATE_WAITFOR_SECONDCLICK))
  {
    CurrentState.SetState(
      Z3D_STATE_WAITFOR_SECONDCLICK);
    return 0;
  }

  //Ok, create the sphere.
  int    nSides    = 16;
  int    Vertices  = 0;
  long  Faces    = 0;
  tPOINT  Center = (*params->LastPressedAt);
  float  fRadius = Dist3D(
    params->ProcessedLocation->x,
    params->ProcessedLocation->y,
    params->ProcessedLocation->z,
    params->LastPressedAt->x,
    params->LastPressedAt->y,
    params->LastPressedAt->z);
  if (fRadius < MINFLOAT)
  {
    AfxMessageBox("Too small Cone!");
    return 0;
  }

  tObject* pObj = new tObject("Cone",
    nSides+2,
    nSides*2);
  // lowest single vertex.
  pObj->VertTable->Table[Vertices].X = Center.x;
  pObj->VertTable->Table[Vertices].Y = Center.y;
  pObj->VertTable->Table[Vertices].Z = Center.z;
  pObj->VertTable->Table[Vertices].NormalX = 0.0f;
  pObj->VertTable->Table[Vertices].NormalY = -1.0f;
  pObj->VertTable->Table[Vertices].NormalZ = 0.0f;
  Vertices++;
  // upper single vertex.
  pObj->VertTable->Table[Vertices].X = Center.x;
  pObj->VertTable->Table[Vertices].Y = Center.y + 2.0f*fRadius;
  pObj->VertTable->Table[Vertices].Z = Center.z;
  pObj->VertTable->Table[Vertices].NormalX = 0.0f;
  pObj->VertTable->Table[Vertices].NormalY = 1.0f;
  pObj->VertTable->Table[Vertices].NormalZ = 0.0f;
  Vertices++;

  int j;
  for (j = 0; j < nSides; j++)
  {//create for
    pObj->VertTable->Table[Vertices].X = Center.x +
      (float)(cos(fdivide(j*M_PI, nSides/2)))*fRadius;
    pObj->VertTable->Table[Vertices].Y = Center.y;
    pObj->VertTable->Table[Vertices].Z = Center.z +
      (float)(sin(fdivide(j*M_PI, nSides/2)))*fRadius;
    pObj->VertTable->Table[Vertices].NormalX =
      (pObj->VertTable->Table[Vertices].X-Center.x)/fRadius;
    pObj->VertTable->Table[Vertices].NormalY = 0.0f;
    pObj->VertTable->Table[Vertices].NormalZ =
      (pObj->VertTable->Table[Vertices].Z-Center.z)/fRadius;
    Vertices++;
  }//create for

  for (j = 0; j < nSides; j++)
  {
    pObj->FaceTable->Table[Faces].I1 = 0;
    pObj->FaceTable->Table[Faces].I2 = 2+(j+1)%nSides;
    pObj->FaceTable->Table[Faces].I3 = 2+j;
    Faces++;
    pObj->FaceTable->Table[Faces].I1 = 1;
    pObj->FaceTable->Table[Faces].I2 = 2+j;
    pObj->FaceTable->Table[Faces].I3 = 2+(j+1)%nSides;
    Faces++;
  }

  Axis = Center;
  float angle = M_PI/2.0f;

  z3dLevels level = CurrentState.GetLevel();
  CurrentState.SetLevel(Z3D_LEVEL_OBJECTS);
  pObj->VertTable->MarkAll();
  if (IsSide(params->ViewDesc->Kind))
  {
    tPOINT axis = tPOINT(0.0f, 0.0f, 1.0f);
    pObj->Rotate(
      params->ViewDesc,
      angle,
      TRUE,
      FALSE,
      axis,
      Center);
  }
  if (IsFrontal(params->ViewDesc->Kind))
  {
    tPOINT axis = tPOINT(1.0f, 0.0f, 0.0f);
    pObj->Rotate(
      params->ViewDesc,
      angle,
      TRUE,
      FALSE,
      axis,
      Center);
  }
  pObj->VertTable->UnMarkAll();
  CurrentState.SetLevel(level);
  pObj->nRequire = Z3D_PLUGRESULT_REDRAW;

  params->Objects->AddObject(pObj);
  delete pObj;

  CurrentState.SetState(Z3D_STATE_WAITFOR_FIRSTCLICK);
  return Z3D_PLUGRESULT_VIEWSREDRAW;
}

DWORD CALLBACK ConeOnMouseMove(tProcParams* params)
{
  // if we are still expecting first click,
  // then do nothing - user simply moves the
  // mouse currently.
  if (!CurrentState.IsState(
    Z3D_STATE_WAITFOR_SECONDCLICK))
    return 0;

  // the tool doesn's support UVMapper view
  if (params->ViewDesc->Kind == Z3D_VIEWMODE_MAPPER)
    return 0;

  // if we got here, we are expecting for the second
  // click. So, draw the circular shape:

  float  fRadius;
  int    iRadius;
  fRadius = Dist3D(
    params->ProcessedLocation->x,
    params->ProcessedLocation->y,
    params->ProcessedLocation->z,
    params->LastPressedAt->x,
    params->LastPressedAt->y,
    params->LastPressedAt->z);
  if (params->ViewDesc->Kind == Z3D_VIEWMODE_USER)
    iRadius = (int)(fRadius*(
      (params->ViewDesc->ClientRect.bottom - params->ViewDesc->ClientRect.top)/
      (2.0f*tan(params->ViewDesc->CamFOV/360.0f*M_PI)*params->ViewDesc->Zoom)));
  else
    iRadius = (int)(fRadius*params->ViewDesc->Zoom);
  POINT center = ConvertToScreen(
    params->LastPressedAt->x,
    params->LastPressedAt->y,
    params->LastPressedAt->z,
    params->ViewDesc);
  params->pdc->SelectStockObject(NULL_BRUSH);
  params->pdc->SelectObject((CPen*)Global.PenThinBlueCreate);

  params->pdc->Ellipse(
    center.x-iRadius,
    center.y-iRadius,
    center.x+iRadius,
    center.y+iRadius);
  params->pdc->SelectObject((CPen*)Global.PenThinBlack);
  return  Z3D_PLUGRESULT_MANUALDRAW |
      Z3D_PLUGRESULT_NOCOVER;
}
